forvalues i = 2004/2019 {
	use "${tmp}/stock_`=substr(string(`i'), 3, 2)'", clear
	rename *, lower
	
	keep siret depcom_et apet eff_et depcom_et age_entreprise
	gen year =`i'
	
	if `i' != 2004 {
		append using "${tmp}/REE_stock"
	}
	save "${tmp}/REE_stock", replace
}	

use "${tmp}/REE_stock", replace
// Convert depcom to ZE
	rename depcom_et depcom
	drop if substr(depcom, 1, 2) == "97" | substr(depcom, 2, 1) == "A"
	replace depcom = "75056" if substr(depcom,1,2) == "75"
	replace depcom = "13055" if inrange(real(depcom),13201,13216)
	replace depcom = "69123" if inrange(real(depcom),69381,69389)
	replace depcom = "59183" if depcom == "59540" | depcom == "59248"
	destring depcom, replace force
	drop if mi(depcom) // drops Corsica
	merge m:1 depcom using "${data}/Utils/depcom_ZE_mapping", nogen keep(1 3)	
	drop depart reg depcom libcom
	bys siret year: keep if _n == 1 //few cases
save "${tmp}/siret_info", replace	




foreach y of numlist 2004(1)2019 {
	global y `y'
	use  siren nbheur s_brut  catjur catjur_1 apet apen comt comr pcs pcs_1 filt age duree ${condDADS} using "${tmp}\dads${y}", clear
	destring catjur catjur_1, replace force
	bys siren (catjur): replace catjur = catjur[1]
	// drop Particuliers employeurs
	cap confirm string var siren
	if _rc == 0 {
	drop if inlist(substr(string(catjur),1,1),"1","2","3","5","6")  == 1 & substr(siren,1,1)=="P"
	drop if inlist(substr(string(catjur_1),1,1),"1","2","3","5","6")  == 1 & substr(siren,1,1)=="P"
	}

	*keep if (floor(catjur/1000)==5) // keep private
	gen catjur5 = floor(catjur/1000) == 5
	
	destring siren, replace force
	drop if mi(siren)
	
	replace apet = apen if mi(apet)
	drop apen
	
	if `y'<=2007 {
		ren apet naf_rev1
		merge m:1 siren using "${data}/Utils/Siren_NAF_rev12", nogen keep(1 3) keepusing(naf_rev2)
		merge m:1 naf_rev1 using "${data}/Utils/NAF_rev12_impute", nogen keep(1 3 4 5) update  keepusing(naf_rev2)
		drop naf_rev1
		ren naf_rev2 apet
		}
		
	gen hskill = substr(pcs,1,1)=="3"
	gen job_eng = (substr(pcs,1,2) == "38")
	gen job_tech = (substr(pcs,1,2) == "47")
	gen job_hskill_noneng = (hskill==1 & job_tech==0 &  job_eng== 0 )
	gen other = (job_eng + job_tech + job_hskill_noneng == 0)
	gen job_eng_m40 = job_eng*(age <= 40)
	gen job_eng_p40 = job_eng*(age > 40)
	
	foreach cat in job_eng job_tech job_hskill_noneng other job_eng_m40 job_eng_p40 {
		*gen `cat'_hc = (`cat' == 1)
		gen `cat'_hrs = nbheur *(`cat' == 1)
		gen `cat'_sbrut = s_brut *(`cat' == 1)
		}
			
	//allocate ZE
	gen depcom = comt
	replace depcom = comr if real(substr(depcom,1,2)) >= 98 | depcom == "69999" | regexm(depcom,"ZZZ")

	replace depcom = "75056" if substr(depcom,1,2) == "75"
	replace depcom = "13055" if inrange(real(depcom),13201,13216)
	replace depcom = "69123" if inrange(real(depcom),69381,69389)
	replace depcom = "59183" if depcom == "59540" | depcom == "59248"
	destring depcom, replace force
	drop if mi(depcom) // drops Corsica
	merge m:1 depcom using "${data}/Utils/depcom_ZE_mapping", nogen keep(1 3)
	
	bys ZE2010 apet siren: gen nb_siren = _n == 1 
	bys ZE2010 apet siren: gen nb_siren_eng = (_n == 1) & job_eng > 0 & !mi(job_eng)

	bys ZE2010 apet: egen mean_duree_inge = sum(duree*job_eng)
	bys ZE2010 apet: egen foo = sum(job_eng)
	replace mean_duree_inge = mean_duree_inge / foo
	drop foo
	keep siren catjur nbheur s_brut catjur5 apet job_eng ZE2010
	bys siren ZE2010 apet catjur: egen s_ing = sum(s_brut*job_eng)
	bys siren ZE2010 apet catjur: egen h_ing = sum(nbheur*job_eng)
	bys siren ZE2010 apet catjur: egen s_tot = sum(s_brut)
	bys siren ZE2010 apet catjur: egen h_tot = sum(nbh)
	gcollapse (mean) s_??? h_???, by(siren apet catjur ZE2010) fast
	gen year = ${y}		
	compress	
	save "${tmp}/DADSpri_RD_ZE_NAF_siren_${y}", replace
}


clear
forvalues i = 2005/2019 {
	append using "${tmp}/DADSpri_RD_ZE_NAF_siren_`i'"
}
preserve
	drop ZE2010 apet
	gcollapse (sum) s_ing s_tot h_ing h_tot, by(siren year catjur) fast
	save "${tmp}/list_siren_dads", replace
restore
keep if floor(catjur / 1000) == 5

bys siren ZE2010 (year): keep if _n <= 3
bys siren: egen mean_eng_m3 = mean(s_ing)
bys siren ZE2010 (year): keep if _n == 1
gen etab_crea = 1
gen etab_crea_eng = (s_ing > 0 & s_ing != .)
gen etab_crea_engm3 = (mean_eng_m3 > 0 & mean_eng_m3 != .)
gen etab_crea_wgttot = (s_tot*(h_tot < 1820 * 100)) //do not count huge creations which are siren changes
gen etab_crea_wgteng = (s_ing*(h_ing < 1820 * 100)) //do not count huge creations which are siren changes
gcollapse (sum) etab_crea*, by(apet ZE2010 year)
foreach wgt in tot eng {
	bys ZE2010: egen den = sum(etab_crea_wgt`wgt')
	replace etab_crea_wgt`wgt' = etab_crea_wgt`wgt' / den
	drop den
}
ren apet ape
drop if mi(ape) | mi(ZE2010)
compress
save "${tmp}/firm_crea_dads", replace


use "${tmp}/siret_info", clear
	replace age = lower(age)
	replace age = trim(age)
	gen new = age == "- 1 an" //| age == "1 an" 
	gen siren = substr(siret, 1, 9)
	destring siren, replace
	merge m:1 siren year using "${tmp}/list_siren_dads", keep(1 3) nogen
	recode s_??? h_??? (missing = 0)
	gen newempnolarge = new * (eff_et <= 20)
	gen newemp= new*(eff_et*(eff_et <= 20))
	gen newempnolarge_cj5 = new*(eff_et <= 20 & floor(catjur / 1000) == 5)
	gen newempnolarge_cj5_dads = new*(eff_et <= 20 & floor(catjur / 1000) == 5 & h_tot >= 1820)
	gen newempnolarge_cj5_dads_ing = new*(eff_et <= 20 & floor(catjur / 1000) == 5 & h_ing >= 0 & h_ing < 1820*20)
	
	bys siret: egen start = min(year)
	gen newempnolarge_oldsiren = (year==start)* (eff_et <= 20 & new == 0)
	gen newempnolarge_newsiren = (year==start)* (eff_et <= 20 & new == 1)
	
	gen stock = 1
	gcollapse (sum) new* stock, by(year apet ZE2010) fast
	recode new* (missing = 0)
	gen share_new = new / stock
	bys ZE2010 apet: egen stock2010 = sum(stock*(year==2010))
	bys ZE2010 apet: egen stock0510 = sum(stock*(inrange(year, 2005, 2010)))
	
	bys ZE2010 apet: egen den  = sum((inrange(year, 2005, 2010)))
	replace stock0510  = stock0510/den
	drop den
	gen share_new0510 = new / stock0510
	gen share_newemp = newemp / stock0510
	gen share_newcj = newempnolarge_cj5 / stock0510
	gen share_newempnol = newempnolarge / stock0510
	gen share_newcj5_dads = newempnolarge_cj5_dads/stock0510
	gen share_new_ing = newempnolarge_cj5_dads_ing /stock0510
	replace newempnolarge_oldsiren = newempnolarge_oldsiren/ stock0510
	replace newempnolarge_newsiren = newempnolarge_newsiren/ stock0510
	
	rename apet ape
	merge 1:1 ape ZE2010 year using "${tmp}/firm_crea_dads"
	drop if stock == 0 | stock == .
	keep if inrange(year, 2005, 2019)
	drop _merge
	recode etab_* (missing = 0)
save "${tmp}/firm_crea_dads", replace

